*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Tebuprimphos oxon                              *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Newcode\Diagnostics3.SAS";

libname EPA "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\kapp data";


/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/

data tebuprimphosoxon;
     set epa.tebuprimphosoxon;
run;
proc sort data=tebuprimphosoxon;
     by id;
run;

/*
ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Tebuprimphos Oxon - individual sample curves.resids.rtf" startpage=no;
%scatter_plot(chemical=TebuprimphosOxon);
ods rtf close;
*/

*===> Human vs. Rat;

title "Human vs. Rat: final model 2";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_HR;
PROC NLMIXED data=tebuprimphosoxon  method=firo tech=newrap lis=3 maxiter=20000 /* gconv=0 */;
      PARMS ha=0.9069
			hb=0.1660
			ra=0.6523
			rb=0.5251
			gh1=0.1 to 1 by 0.1  gh12=0.1 to 1 by 0.1 gh2=0.1 to 1 by 0.1
			S2E=0.1 to 1 by 0.1 / best=50;
			gha=gh1*gh1;
			ghab=gh1*gh12;
			ghb=gh12*gh12+gh2*gh2;
            rha=ha+ua;
			rra=ra+ua;
            rhb=hb+ub;
			rrb=rb+ub;
            PRED2 = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-5 + H_I__M + rrb*Rat*1e-6 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  ua ub ~ normal([0, 0],	[gha, 
												 		 ghab, ghb]
														 ) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/(rb*1e-1)); /* extra 1e-1 is because rhb and rrb have different multipliers */
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12+gh2*gh2;
	  id pred2;
	  Predict PRED2 out=Resid_HR;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Tebuprimphos Oxon human-rat.resids.rtf" startpage=no;
%DiagnosticsHR(chemical=tebuprimphosoxon, model=2)
ods rtf close;
*%Calculate_Ki(chemical=tebuprimphosoxon, Hadj=1e-4, Radj=1e-4);

*===> Adult vs. Infant;


title "final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_AI;
PROC NLMIXED data=tebuprimphosoxon(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=0.9	adB=0.2
			ia=0.8 iB=0.1
			gh1=0.1 to 2 by 0.1 gh12=0.1 to 2.0 by 0.1	/* gh2=0 Forced gh2 to be 0 since model with gh2 failed to converge and previous model runs gave neligible values */
			S2E=0.5 to 2 by 0.05 / best = 50;
			gha=gh1*gh1;
			ghab=gh1*gh12/10;
			ghb=gh12*gh12/100 /* + gh2*gh2 */;
			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED2 = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-5 + H_I__M*adult + rib*1e-5*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-4);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_AI;
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
  	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12/10;
	  estimate "ghb" gh12*gh12/100 /* +gh2*gh2 */;
	  id pred2;
	   predict pred2 out=Resid_AI;
run;

%let factor=0.0001;


ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Tebuprimphos Oxon Adult-Infant.resids.rtf" startpage=no;
%DiagnosticsAI(chemical=tebuprimphosoxon, model=2)
ods rtf close;

*===> Male vs. Female;

title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_MF;
PROC NLMIXED data=tebuprimphosoxon(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000 method=firo;
      PARMS ma=0.9482 mb= 0.1683
			fa=.8673 fB=0.1613
			gh1=0.3 gh12=0 gh2=0.1
			S2E=.05965;
			gha=gh1*gh1;
			ghab=gh1*gh12;
			ghb=gh12*gh12+gh2*gh2;
            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
           PRED2 = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-5 + H_I__M*male + rfb*female*1e-5 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
  	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12+gh2*gh2;
	  id pred2;
	  predict pred2 out=Resid_MF;
run;

%let factor=0.001;


ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Tebuprimphos Oxon Male-Female.resids.rtf" startpage=no;
%DiagnosticsMF(chemical=tebuprimphosoxon, model=2)
ods rtf close;


*===> Caucasian vs. Other Races;

title "Final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_CO;
PROC NLMIXED data=tebuprimphosoxon(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ca=.9342	cB=.1758
			ora=0.8558 orB=0.1483
			gh1=0.3 gh12=0 gh2=0.1
			S2E=.06035;
			gha=gh1*gh1;
			ghab=gh1*gh12;
			ghb=gh12*gh12+gh2*gh2;
            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED2 = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-5 + H_I__M*caucasian + rorb*otherrace*1e-5 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_CO;
	 ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasain ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
  	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12+gh2*gh2;
	  id pred2;
	  predict pred2 out=Resid_CO;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Tebuprimphos Oxon Caucasian-Other Races.resids.rtf" startpage=no;
%DiagnosticsCO(chemical=tebuprimphosoxon, model=2)
ods rtf close;

%resids